mEmitSpeed = 1;

mScale = 0;

mBlendMode = GUI_Select(
   kBlendAdditiveAlpha,
      "Blend Mode",
      {
         { description="Normal", value=kBlendNormal},
         { description="Additive", value=kBlendAdditiveAlpha}
      }
);

mTextureName = "white_party";

mMaxParticles = 1;

-- ------------------------------------------------------------
-- Define our particle characteristics

pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

-- Set the particle texture
SetTexture(mTextureName);

-- Set the blend mode
SetBlendMode(mBlendMode);

-- LAST, we set the total number of particles in the particle
-- system. This doesn't 'create' the particles, but rather
-- allocates a block of 'dead' particles that can be created
-- below.
SetNumParticles(mMaxParticles);

-- ------------------------------------------------------------
-- Initialization rules.
-- 
-- The following rules define how particles are created.
--
-- Any parameter below in initialization or animation rules that 
-- is a scalar, Color(), or Vec2() can alternaly take a function 
-- that returns the same type--and most functions can take any type
-- and will return that same type. The exception is any function
-- that's expecting a scalar in certain parameter positions.

-- Define dLocus for FluidFX; in the game it's defined in 
-- swarm.cpp as a data source, and it gets the mouse position.
if not dLocus then
   dLocus= Vec2(0,0) ; 
end

if not dScale then
   dScale = Vec2(1, 1);
end

-- Pick a position randomly, within a range of values.
-- dLocus is defined in swarm.cpp and added to the random
-- range
--pPosition:Init( (fRange( Vec2(-30,-30), Vec2(30,30) ) * dScale[1]) + dLocus );
pPosition:Init( Vec2(0,0) + dLocus );

-- Pick a velocity within a range
--pVelocity:Init( fRange( Vec2(-50,-200), Vec2(50,-320) ) );
pVelocity:Init( Vec2(0,0) );

-- Start scale at 0.5
pScale:Init( mScale );

-- Start age as 0 milliseconds
pAge:Init(0);

-- Start initial rotation as a random angle
--pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpin:Init( 3.1415927 / 2 );

-- Start spin velocity random from -10 to 10
pSpinSpeed:Init( 5 );

-- ------------------------------------------------------------
-- Particle Parameter Animation Functions
--
-- The following rules define how particles animate.
-- Each rule is applied on each frame of animation.

-- Add velocity scaled by time to position
--pPosition:Anim( pPosition + fTimeScale(pVelocity) );

-- Add 1/second to scale
pScale:Anim( f2dRotation( pSpin ) * 2 );

-- Add gravity scaled by time to velocity
--pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,250)) );

-- Fade (using age) from white to yellow to black. Assumes
-- the first parameter is a number of elapsed milliseconds,
-- though can work to linearly interpolate using first 
-- scalar parameter between any value types.
--pColor:Anim( 
--   fFade( pAge,
--      Color(1,1,1,1),400,
--      Color(1,1,1,1) ) -- to final color
--   );

pColor:Anim( 
   fFade( pAge,
      Color(1,1,0,1),600,
      Color(1,1,0,1),200,
      Color(1,1,0,0) ) -- to final color
   );

-- Spin by pSpinSpeed scaled by time
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Set the particle's "Up" vector to the current user variable
-- "pSpin"
pUp:Anim( f2dRotation( pSpin ) );

-- Age the particle using age function
pAge:Anim( pAge+fAge() );

-- General Anim functions
-- Expire particles over 700 ms old
Anim( fExpire( fGreater(pAge,2000) ) );

pPosition:Anim( Vec2(0,0) + dLocus );

-- ------------------------------------------------------------
-- Create initial particles (optional)
-- CreateParticles( 1 );

-- ------------------------------------------------------------

-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   CreateParticles( seconds * mEmitSpeed );
end
